clear all
set more off
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"

use wf_step1011.dta, clear
capture log close
log using C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\log_files\step2006.log, replace

*** Population weights
egen sum_age_total = sum(age_total) if smpl2==1, by(year country)
gen pop_wgt =  age_total/sum_age_total


reg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp mlog_road_density city_nuts capital ///
			cid_* [aw=pop_wgt]  if smpl2==1 & year==1971, robust beta 
			
keep if e(sample)			
*==============================================================
*					No fixed effects
*==============================================================
foreach country0 in AT BE CA CH DE DK ES FI FR IT NL SE UK US {
	capture drop flag_`country0'
	gen flag_`country0'=(country=="`country0'")
}

gen flag_all=1
	
					
tempname 1 
postfile `1' str100 variable ///
			str10 AT str10 BE str10 CA ///
			str10 CH str10 DE str10 DK ///
			str10 ES str10 FI str10 FR ///
			str10 IT str10 NL str10 SE ///
			str10 UK str10 US str10 all ///
			using C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\output_dta\temp_Table5004, replace every(1)
	
			
foreach var in ///
			ue2_hyst turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp mlog_road_density city_nuts capital ///
				{			
				di "==============================="
				di "`var_bloc'"
				
				
				foreach country0 in AT BE CA CH DE DK ES FI FR IT NL SE UK US all {
					
							sum `var' [aw=pop_wgt] if flag_`country0'==1
							local c_mean_`country0'	=	string(r(mean),"%5.2f")
							local c_sd_`country0'	=	"(" + string(r(sd),"%5.2f") + ")"

							
						
				}
				
				post `1' ("`var'") ///
						 ("`c_mean_AT'") 	("`c_mean_BE'") 	("`c_mean_CA'") ///
						 ("`c_mean_CH'")	("`c_mean_DE'")		("`c_mean_DK'") ///
						 ("`c_mean_ES'")	("`c_mean_FI'")		("`c_mean_FR'") ///
						 ("`c_mean_IT'")	("`c_mean_NL'")		("`c_mean_SE'") ///
						 ("`c_mean_UK'")	("`c_mean_US'")		("`c_mean_all'") 


				post `1' ("`var'") ///
						 ("`c_sd_AT'") 	("`c_sd_BE'") 		("`c_sd_CA'") ///
						 ("`c_sd_CH'")	("`c_sd_DE'")		("`c_sd_DK'") ///
						 ("`c_sd_ES'")	("`c_sd_FI'")		("`c_sd_FR'") ///
						 ("`c_sd_IT'")	("`c_sd_NL'")		("`c_sd_SE'") ///
						 ("`c_sd_UK'")	("`c_sd_US'")		("`c_sd_all'") 				
			
}					

				foreach country0 in AT BE CA CH DE DK ES FI FR IT NL SE UK US all {
					
							sum `var' [aw=pop_wgt] if flag_`country0'==1
							local c_mean_`country0'	=	string(r(N),"%5.0f")

							
						
				}
				
				post `1' ("N regions") ///
						 ("`c_mean_AT'") 	("`c_mean_BE'") 	("`c_mean_CA'") ///
						 ("`c_mean_CH'")	("`c_mean_DE'")		("`c_mean_DK'") ///
						 ("`c_mean_ES'")	("`c_mean_FI'")		("`c_mean_FR'") ///
						 ("`c_mean_IT'")	("`c_mean_NL'")		("`c_mean_SE'") ///
						 ("`c_mean_UK'")	("`c_mean_US'")		("`c_mean_all'") 
						 
						 
						 
postclose `1'

